﻿<%@ Page Language="C#" MasterPageFile="~/TBI_Instruments/RegistryInstrument.master" AutoEventWireup="true" CodeFile="OptimalFollowUp.aspx.cs"
    Inherits="TBI_Instruments_OptimalFollowUp" Title="" EnableEventValidation="false" %>


<%@ Import Namespace="VeteransAffairs.Registries.Business" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="ajaxToolkit" %>
<%@ Register Namespace="CustomValidators" Assembly="__code" tagprefix="web" %>

<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="Server">
    <link type="text/css" href="~/styles/StyleSheet.css" />
    <style type="text/css">
        .breadcrumbInstrument
        {
            background-color: #6B1424;
            border-bottom: 1px solid #000;
            color: #FFF;
            font-family: Verdana, Geneva, Arial, Helvetica, sans-serif;
            font-variant: small-caps;
            font-weight: 700;
            letter-spacing: 1px;
            margin: 2px 0 2px 0;
            padding: 8px 25px 5px 10px;
        }
        .requiredField 
        {
        	font-weight:bold;
        	color:#FF0000;
        }

         table.radioWithProperWrap input
         {    
              float: left;
         }

         table.radioWithProperWrap label
         {    
              margin-left: 25px;
              display: block;
         }
    </style>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder" runat="Server">

    <asp:ScriptManager ID="ScriptManager1" runat="server">
    </asp:ScriptManager>

<telerik:RadCodeBlock runat="server" ID="RadCodeBlock1">
        <script type="text/javascript">
            var tmr = null;

            function getTimerReference() {
                if (tmr == null) {
                    tmr = $find("<%= InactiveTimer.ClientID %>");
                }

                return tmr;
            }

            function StopTimer() {
                // alert('stop');
                getTimerReference()._stopTimer();
            }

            function StartTimer() {
                //alert('start');
                getTimerReference()._startTimer();
            }

            function startRequest(sender, e) {
                StartTimer();
                //disable button during the AJAX call
                document.getElementById('<%=btnSaveSurveyDraft.ClientID%>').disabled = true;
            document.getElementById('<%=btnSubmitSurvey.ClientID%>').disabled = true;
            document.getElementById('<%=btnCancelSurvey.ClientID%>').disabled = true;
        }
        function endRequest(sender, e) {
            //re-enable button once the AJAX call has completed
            document.getElementById('<%=btnSaveSurveyDraft.ClientID%>').disabled = false;
            document.getElementById('<%=btnSubmitSurvey.ClientID%>').disabled = false;
            document.getElementById('<%=btnCancelSurvey.ClientID%>').disabled = true;
        }
        </script>

        <script type="text/javascript">
            $(document).ready(function () {

                //Disables 'Enter' Key from posting back on any input element ( textbox, radiolist, checkbox, etc )
                //also resets inactive timer
                $('input').keydown(function (e) {
                    StopTimer();
                    StartTimer();
                    //if (e.keyCode == 13) { return false; }
                });

                //Disables 'Enter' Key from posting back when no input element is in focus, and the enter key is presssed
                //also resets inactive timer
                $('div').keydown(function (e) {
                    StopTimer();
                    StartTimer();
                    //if (e.keyCode == 13) { return false; }
                });

                //resets inactive timer on click of a radio element
                $('input[type=radio]').click(function (e) {
                    StopTimer();
                    StartTimer();
                });

                //resets inactive timer on click of a checkbox element
                $('input[type=checkbox]').click(function (e) {
                    StopTimer();
                    StartTimer();
                });

                window.onbeforeunload = function () {
                    return;
                }

            });

            function clearRadioButtonListSelection(listName) 
            {
                var rbList = document.getElementById(listName);
                var radio = rbList.getElementsByTagName("input");

                var currIndex = GetListIndexSelected(listName);
                if (currIndex > -1) {
                    radio[currIndex].checked = false;
                }
            }

            function GetListIndexSelected(listName) {
                var rbList = document.getElementById(listName);
                var radio = rbList.getElementsByTagName("input");
                var ret = -1;

                for (var i = 0; i < radio.length; i++) {
                    if (radio[i].checked) {
                        ret = i;
                        break;
                    }
                }

                return ret;

            } 
            
            function GetLastElementIndex(listName) {
                var rbList = document.getElementById(listName);
                var radio = rbList.getElementsByTagName("input");
                var ret = -1;

                ret = radio.length - 1;

                return ret;
            }

            function btnSaveButtonChange_Click() {

            }
            

        </script>

    </telerik:RadCodeBlock>
    <telerik:RadCodeBlock runat="server" ID="RadCodeBlock2">
        <div class="breadcrumbInstrument">
            <asp:Label ID="LabelBreadCrumb" runat="server" SkinID="DataLabel" Text="TBI Instruments > Instrument Associations > Optimal 1.1 Follow Up"></asp:Label>
        </div>
    </telerik:RadCodeBlock>
    <telerik:RadCodeBlock runat="server" ID="RadCodeBlock3">
        <asp:UpdatePanel ID="MainUpdatePanel" runat="server">
            <ContentTemplate>
                <asp:UpdateProgress ID="MainUpdateProgress" runat="server">
                    <ProgressTemplate>
                        <!-- Modal Popup for Loading -->
                        <div style="padding-left: 3px;">
                            <div style="background-color: #FF0000; width: 170px; color: #FFFFFF; padding: 5px;">
                                Processing...Please wait.
                            </div>
                        </div>
                    </ProgressTemplate>
                </asp:UpdateProgress>
                <asp:ValidationSummary ID="TBIInstrumentsValidationSummaryOnSave" runat="server" TabIn="1" HeaderText="The page has the following data errors:"
                    DisplayMode="BulletList" ShowSummary="false" ShowMessageBox="true" ValidationGroup="OnSave" />
                <asp:Panel ID="PanelPatient" Width="100%" GroupingText="&nbsp;&nbsp;Patient&nbsp;&nbsp;" runat="server">
                    <table cellpadding="5" cellspacing="5">
                        <tr>
                            <td>&nbsp;&nbsp;<asp:Label ID="LabelForName" runat="server" Text="Patient:" SkinID="DataLabel" AssociatedControlID="LabelPatient"></asp:Label>&nbsp;<asp:Label
                                ID="LabelPatient" runat="server" SkinID="DataLabel" TabIn="2"></asp:Label>
                            </td>
                            <td>
                                <asp:Label ID="LabelForSSN" runat="server" SkinID="DataLabel" AssociatedControlID="LabelSSN" Text="SSN:"></asp:Label>
                                &nbsp;<asp:Label ID="LabelSSN" runat="server" SkinID="DataLabel" TabIn="3"></asp:Label>
                            </td>
                            <td>
                                <asp:Label ID="LabelForFacility" runat="server" SkinID="DataLabel" AssociatedControlID="LabelFacility" Text="Facility:" Visible="false"></asp:Label>
                                &nbsp;<asp:Label ID="LabelFacility" runat="server" SkinID="DataLabel" TabIn="4"></asp:Label>
                            </td>
                        </tr>
                    </table>
                </asp:Panel>

                <!-- Hidden Field - Survey Type -->
                <asp:HiddenField ID="HiddenSurveyType" runat="server" Visible="false" Value="Optimal Follow Up" />
                <asp:Panel ID="PanelSurveyHeader" Width="100%" runat="server" CssClass="mainContent">
                    <br />
                    <asp:Label ID="LabelInstrumentTitle" runat="server" SkinID="DataLabel"  Style="font-weight: bold" />
                    <br />
                </asp:Panel>
                <asp:Panel ID="pnlQuestions" Width="100%" runat="server" CssClass="mainContent">
                    <!-- Question Area -->
                   <%-- Top level panel to get Patient Status, Diagnosis, Work status, Housing status, and living arrangement status
                    --%><br />
                    <br />                                            
                    <table id="rbl1">         
                         <tr>
                            <td style="width: 33%;">
                                <!--Date-->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelDate1" runat="server" AssociatedControlID="dpDate1" SkinID="DataLabel" TabIn="5" Visible="False">
                                </asp:Label>
                            </td>
                            <td colspan="2">
                                <!--Date picker-->
                                <telerik:RadDatePicker ID="dpDate1" runat="server" TabIn="6" Visible="False">
                                    <Calendar ID="calDate1" runat="server">
                                    </Calendar>
                                </telerik:RadDatePicker>
                                <!--Date 1 required field validator (only one required)-->
                                <br />
                               <%-- <asp:RequiredFieldValidator ID="RequiredFieldValidatorDate1" runat="server" ControlToValidate="dpDate1" TabIn="7" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Date is required." Visible="False"></asp:RequiredFieldValidator>--%>
                            </td>
                        </tr>                  
                       

                    </table>
                    <br />
                <asp:Panel ID="pnlBaselineDifficulty" runat="server">
                    <table style="width: 1000px;" cellpadding="5" >

                        <tr>
                            <td colspan="3">
                                <asp:Label ID="LabelforFollowUpDifficulty" AssociatedControlID="pnlBaselineDifficulty"  SkinID="DataLabel" runat="server" TabIn="7">Follow Up Difficulty</asp:Label>
                            </td>
                        </tr>


                        <tr>
                            <td style="width: 20px;">&nbsp;
                            </td>
                            <td colspan="2">

                                <br />
                                <asp:Label ID="LabelforInstructions" AssociatedControlID="pnlBaselineDifficulty"  SkinID="DataLabel"  runat="server" TabIn="8"><strong>
                                    Instructions: Please select the level of difficulty you have for each activity today.

                                </strong></asp:Label>
                                
                                <br />

                            </td>

                        </tr>



                        <tr>
                            <td style="width: 20px;">&nbsp;
                            </td>
                            <td style="width: 280px;">
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ1" runat="server" AssociatedControlID="rblQdifficulty1" SkinID="DataLabel" TabIn="9">
                                <%=GetQuestionText("Follow Up Difficulty-1")%>
                                </asp:Label>
                            </td>
                            <td style="width: 700px;">
                                <%--Question 1 Choice List--%>
                                <asp:RadioButtonList   name="rblQdifficulty" ID="rblQdifficulty1" runat="server" RepeatDirection="horizontal" SkinID="DataLabel"  DataSourceID="ObjectDataSourceQ1" TabIn="10"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="radioWithProperWrap" RepeatLayout="Table" ValidationGroup="OnSave" 
                                    AutoPostBack="false">
                                </asp:RadioButtonList>
                                <%--Question 1 Required Validator--%>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ1" runat="server" ControlToValidate="rblQdifficulty1" SkinID="DataLabel" TabIn="11" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Question 1 Selection is required."></asp:RequiredFieldValidator>
                                <%--Question 1 Object Data Source--%>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ1" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ1" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Question 1 : Question Number--%>
                                <asp:HiddenField ID="HiddenQ1" runat="server" Visible="false" Value="Follow Up Difficulty-1" />
                            </td>
                        </tr>
                        <tr>
                            <td>&nbsp;
                            </td>
                            <td>
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ2" runat="server" AssociatedControlID="rblQdifficulty2" SkinID="DataLabel" TabIn="12">
                                     <%=GetQuestionText("Follow Up Difficulty-2")%>
                                </asp:Label>
                            </td>
                            <td>
                                <%--Question 2 Choice List--%>
                                <asp:RadioButtonList   name="rblQdifficulty" ID="rblQdifficulty2" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ2" SkinID="DataLabel" TabIn="13"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="radioWithProperWrap" RepeatLayout="Table" ValidationGroup="OnSave" 
                                    AutoPostBack="false">
                                </asp:RadioButtonList>
                                <%--Question 2 Required Validator--%>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ2" runat="server" ControlToValidate="rblQdifficulty2" SkinID="DataLabel" TabIn="14" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Question 2 Selection is required."></asp:RequiredFieldValidator>
                                <%--Question 2 Object Data Source--%>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ2" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ2" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Question 2 : Question Number--%>
                                <asp:HiddenField ID="HiddenQ2" runat="server" Visible="false" Value="Follow Up Difficulty-2" />
                            </td>
                        </tr>
                        <tr>
                            <td>&nbsp;
                            </td>
                            <td>
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ3" runat="server" AssociatedControlID="rblQdifficulty3" SkinID="DataLabel" TabIn="15">
                                     <%=GetQuestionText("Follow Up Difficulty-3")%>
                                </asp:Label>
                            </td>
                            <td>
                                <%--Question 3 Choice List--%>
                                <asp:RadioButtonList   name="rblQdifficulty" ID="rblQdifficulty3" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ3" SkinID="DataLabel"  TabIn="16"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="radioWithProperWrap" RepeatLayout="Table" ValidationGroup="OnSave" 
                                    AutoPostBack="false">
                                </asp:RadioButtonList>
                                <%--Question 3 Required Validator--%>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ3" runat="server" ControlToValidate="rblQdifficulty3" SkinID="DataLabel" TabIn="17" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Question 3 Selection is required."></asp:RequiredFieldValidator>
                                <%--Question 3 Object Data Source--%>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ3" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ3" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Question 3 : Question Number--%>
                                <asp:HiddenField ID="HiddenQ3" runat="server" Visible="false" Value="Follow Up Difficulty-3" />
                            </td>
                        </tr>
                        <tr>
                            <td>&nbsp;
                            </td>
                            <td>
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ4" runat="server" AssociatedControlID="rblQdifficulty4" SkinID="DataLabel" TabIn="18">
                                     <%=GetQuestionText("Follow Up Difficulty-4")%>
                                </asp:Label>
                            </td>
                            <td>
                                <%--Question 4 Choice List--%>
                                <asp:RadioButtonList   name="rblQdifficulty" ID="rblQdifficulty4" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ4" SkinID="DataLabel" TabIn="19"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="radioWithProperWrap" RepeatLayout="Table" ValidationGroup="OnSave" 
                                    AutoPostBack="false">
                                </asp:RadioButtonList>
                                <%--Question 4 Required Validator--%>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ4" runat="server" ControlToValidate="rblQdifficulty4" SkinID="DataLabel" TabIn="20" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Question 4 Selection is required."></asp:RequiredFieldValidator>
                                <%--Question 4 Object Data Source--%>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ4" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ4" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Question 4 : Question Number--%>
                                <asp:HiddenField ID="HiddenQ4" runat="server" Visible="false" Value="Follow Up Difficulty-4" />
                            </td>
                        </tr>
                        <tr>
                            <td>&nbsp;
                            </td>
                            <td>
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ5" runat="server" AssociatedControlID="rblQdifficulty5" SkinID="DataLabel" TabIn="21">
                                     <%=GetQuestionText("Follow Up Difficulty-5")%>
                                </asp:Label>
                            </td>
                            <td>
                                <%--Question 5 Choice List--%>
                                <asp:RadioButtonList   name="rblQdifficulty" ID="rblQdifficulty5" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ5" SkinID="DataLabel" TabIn="22"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="radioWithProperWrap" RepeatLayout="Table" ValidationGroup="OnSave" 
                                    AutoPostBack="false">
                                </asp:RadioButtonList>
                                <%--Question 5 Required Validator--%>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ5" runat="server" ControlToValidate="rblQdifficulty5" SkinID="DataLabel" TabIn="23" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Question 5 Selection is required."></asp:RequiredFieldValidator>
                                <%--Question 5 Object Data Source--%>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ5" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ5" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Question 5 : Question Number--%>
                                <asp:HiddenField ID="HiddenQ5" runat="server" Visible="false" Value="Follow Up Difficulty-5" />
                            </td>
                        </tr>
                        <tr>
                            <td>&nbsp;
                            </td>
                            <td>
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ6" runat="server" AssociatedControlID="rblQdifficulty6" SkinID="DataLabel" TabIn="24">
                                     <%=GetQuestionText("Follow Up Difficulty-6")%>
                                </asp:Label>
                            </td>
                            <td>
                                <%--Question 6 Choice List--%>
                                <asp:RadioButtonList   name="rblQdifficulty" ID="rblQdifficulty6" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ6" SkinID="DataLabel" TabIn="25"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="radioWithProperWrap" RepeatLayout="Table" ValidationGroup="OnSave" 
                                    AutoPostBack="false">
                                </asp:RadioButtonList>
                                <%--Question 6 Required Validator--%>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ6" runat="server" ControlToValidate="rblQdifficulty6" SkinID="DataLabel" TabIn="26" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Question 6 Selection is required."></asp:RequiredFieldValidator>
                                <%--Question 6 Object Data Source--%>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ6" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ6" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Question 6 : Question Number--%>
                                <asp:HiddenField ID="HiddenQ6" runat="server" Visible="false" Value="Follow Up Difficulty-6" />
                            </td>
                        </tr>
                        <tr>
                            <td>&nbsp;
                            </td>
                            <td>
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ7" runat="server" AssociatedControlID="rblQdifficulty7" SkinID="DataLabel" TabIn="27">
                                     <%=GetQuestionText("Follow Up Difficulty-7")%>
                                </asp:Label>
                            </td>
                            <td>
                                <%--Question 7 Choice List--%>
                                <asp:RadioButtonList   name="rblQdifficulty" ID="rblQdifficulty7" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ7" SkinID="DataLabel" TabIn="28"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="radioWithProperWrap" RepeatLayout="Table" ValidationGroup="OnSave" 
                                    AutoPostBack="false">
                                </asp:RadioButtonList>
                                <%--Question 7 Required Validator--%>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ7" runat="server" ControlToValidate="rblQdifficulty7" SkinID="DataLabel" TabIn="29" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Question 7 Selection is required."></asp:RequiredFieldValidator>
                                <%--Question 7 Object Data Source--%>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ7" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ7" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Question 7 : Question Number--%>
                                <asp:HiddenField ID="HiddenQ7" runat="server" Visible="false" Value="Follow Up Difficulty-7" />
                            </td>
                        </tr>

                        <tr>
                            <td>&nbsp;
                            </td>
                            <td>
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ8" runat="server" AssociatedControlID="rblQdifficulty8" SkinID="DataLabel" TabIn="30">
                                     <%=GetQuestionText("Follow Up Difficulty-8")%>
                                </asp:Label>
                            </td>
                            <td>
                                <%--Question 8 Choice List--%>
                                <asp:RadioButtonList   name="rblQdifficulty" ID="rblQdifficulty8" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ8" SkinID="DataLabel" TabIn="31"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="radioWithProperWrap" RepeatLayout="Table" ValidationGroup="OnSave" 
                                    AutoPostBack="false">
                                </asp:RadioButtonList>
                                <%--Question 8 Required Validator--%>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ8" runat="server" ControlToValidate="rblQdifficulty8" SkinID="DataLabel" TabIn="32" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Question 8 Selection is required."></asp:RequiredFieldValidator>
                                <%--Question 8 Object Data Source--%>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ8" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ8" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Question 8 : Question Number--%>
                                <asp:HiddenField ID="HiddenQ8" runat="server" Visible="false" Value="Follow Up Difficulty-8" />
                            </td>
                        </tr>
                        <tr>
                            <td>&nbsp;
                            </td>
                            <td>
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ9" runat="server" AssociatedControlID="rblQdifficulty9" SkinID="DataLabel" TabIn="33">
                                     <%=GetQuestionText("Follow Up Difficulty-9")%>
                                </asp:Label>
                            </td>
                            <td>
                                <%--Question 9 Choice List--%>
                                <asp:RadioButtonList   name="rblQdifficulty" ID="rblQdifficulty9" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ9" SkinID="DataLabel" TabIn="34"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="radioWithProperWrap" RepeatLayout="Table" ValidationGroup="OnSave" 
                                    AutoPostBack="false">
                                </asp:RadioButtonList>
                                <%--Question 9 Required Validator--%>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ9" runat="server" ControlToValidate="rblQdifficulty9" SkinID="DataLabel" TabIn="35" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Question 9 Selection is required."></asp:RequiredFieldValidator>
                                <%--Question 9 Object Data Source--%>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ9" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ9" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Question 9 : Question Number--%>
                                <asp:HiddenField ID="HiddenQ9" runat="server" Visible="false" Value="Follow Up Difficulty-9" />
                            </td>
                        </tr>
                        <tr>
                            <td>&nbsp;
                            </td>
                            <td>
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ10" runat="server" AssociatedControlID="rblQdifficulty10" SkinID="DataLabel" TabIn="36">
                                     <%=GetQuestionText("Follow Up Difficulty-10")%>
                                </asp:Label>
                            </td>
                            <td>
                                <%--Question 10 Choice List--%>
                                <asp:RadioButtonList   name="rblQdifficulty" ID="rblQdifficulty10" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ10" SkinID="DataLabel" TabIn="37"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="radioWithProperWrap" RepeatLayout="Table" ValidationGroup="OnSave" 
                                    AutoPostBack="false">
                                </asp:RadioButtonList>
                                <%--Question 10 Required Validator--%>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ10" runat="server" ControlToValidate="rblQdifficulty10" SkinID="DataLabel" TabIn="38" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Question 10 Selection is required."></asp:RequiredFieldValidator>
                                <%--Question 10 Object Data Source--%>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ10" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ10" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Question 10 : Question Number--%>
                                <asp:HiddenField ID="HiddenQ10" runat="server" Visible="false" Value="Follow Up Difficulty-10" />
                            </td>
                        </tr>
                        <tr>
                            <td>&nbsp;
                            </td>
                            <td>
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ11" runat="server" AssociatedControlID="rblQdifficulty11" SkinID="DataLabel" TabIn="39">
                                     <%=GetQuestionText("Follow Up Difficulty-11")%>
                                </asp:Label>
                            </td>
                            <td>
                                <%--Question 11 Choice List--%>
                                <asp:RadioButtonList   name="rblQdifficulty" ID="rblQdifficulty11" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ11" SkinID="DataLabel" TabIn="40"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="radioWithProperWrap" RepeatLayout="Table" ValidationGroup="OnSave" 
                                    AutoPostBack="false">
                                </asp:RadioButtonList>
                                <%--Question 11 Required Validator--%>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ11" runat="server" ControlToValidate="rblQdifficulty11" SkinID="DataLabel" TabIn="41" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Question 11 Selection is required."></asp:RequiredFieldValidator>
                                <%--Question 11 Object Data Source--%>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ11" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ11" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Question 11 : Question Number--%>
                                <asp:HiddenField ID="HiddenQ11" runat="server" Visible="false" Value="Follow Up Difficulty-11" />
                            </td>
                        </tr>
                        <tr>
                            <td>&nbsp;
                            </td>
                            <td>
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ12" runat="server" AssociatedControlID="rblQdifficulty12" SkinID="DataLabel" TabIn="42">
                                     <%=GetQuestionText("Follow Up Difficulty-12")%>
                                </asp:Label>
                            </td>
                            <td>
                                <%--Question 12 Choice List--%>
                                <asp:RadioButtonList   name="rblQdifficulty" ID="rblQdifficulty12" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ12" SkinID="DataLabel" TabIn="43"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="radioWithProperWrap" RepeatLayout="Table" ValidationGroup="OnSave" 
                                    AutoPostBack="false">
                                </asp:RadioButtonList>
                                <%--Question 12 Required Validator--%>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ12" runat="server" ControlToValidate="rblQdifficulty12" SkinID="DataLabel" TabIn="44" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Question 12 Selection is required."></asp:RequiredFieldValidator>
                                <%--Question 12 Object Data Source--%>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ12" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ12" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Question 12 : Question Number--%>
                                <asp:HiddenField ID="HiddenQ12" runat="server" Visible="false" Value="Follow Up Difficulty-12" />
                            </td>
                        </tr>
                        <tr>
                            <td>&nbsp;
                            </td>
                            <td>
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ13" runat="server" AssociatedControlID="rblQdifficulty13" SkinID="DataLabel" TabIn="45">
                                     <%=GetQuestionText("Follow Up Difficulty-13")%>
                                </asp:Label>
                            </td>
                            <td>
                                <%--Question 13 Choice List--%>
                                <asp:RadioButtonList   name="rblQdifficulty" ID="rblQdifficulty13" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ13" SkinID="DataLabel" TabIn="46"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="radioWithProperWrap" RepeatLayout="Table" ValidationGroup="OnSave" 
                                    AutoPostBack="false">
                                </asp:RadioButtonList>
                                <%--Question 13 Required Validator--%>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ13" runat="server" ControlToValidate="rblQdifficulty13" SkinID="DataLabel" TabIn="47" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Question 13 Selection is required."></asp:RequiredFieldValidator>
                                <%--Question 13 Object Data Source--%>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ13" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ13" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Question 13 : Question Number--%>
                                <asp:HiddenField ID="HiddenQ13" runat="server" Visible="false" Value="Follow Up Difficulty-13" />
                            </td>
                        </tr>
                        <tr>
                            <td>&nbsp;
                            </td>
                            <td>
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ14" runat="server" AssociatedControlID="rblQdifficulty14" SkinID="DataLabel" TabIn="48">
                                     <%=GetQuestionText("Follow Up Difficulty-14")%>
                                </asp:Label>
                            </td>
                            <td>
                                <%--Question 14 Choice List--%>
                                <asp:RadioButtonList   name="rblQdifficulty" ID="rblQdifficulty14" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ14" SkinID="DataLabel" TabIn="49"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="radioWithProperWrap" RepeatLayout="Table" ValidationGroup="OnSave" 
                                    AutoPostBack="false">
                                </asp:RadioButtonList>
                                <%--Question 14 Required Validator--%>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ14" runat="server" ControlToValidate="rblQdifficulty14" SkinID="DataLabel" TabIn="50" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Question 14 Selection is required."></asp:RequiredFieldValidator>
                                <%--Question 14 Object Data Source--%>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ14" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ14" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Question 14 : Question Number--%>
                                <asp:HiddenField ID="HiddenQ14" runat="server" Visible="false" Value="Follow Up Difficulty-14" />
                            </td>
                        </tr>

                        <tr>
                            <td>&nbsp;
                            </td>
                            <td>
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ15" runat="server" AssociatedControlID="rblQdifficulty15" SkinID="DataLabel" TabIn="51">
                                     <%=GetQuestionText("Follow Up Difficulty-15")%>
                                </asp:Label>
                            </td>
                            <td>
                                <%--Question 15 Choice List--%>
                                <asp:RadioButtonList   name="rblQdifficulty" ID="rblQdifficulty15" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ15" SkinID="DataLabel" TabIn="52"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="radioWithProperWrap" RepeatLayout="Table" ValidationGroup="OnSave" 
                                    AutoPostBack="false">
                                </asp:RadioButtonList>
                                <%--Question 15 Required Validator--%>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ15" runat="server" ControlToValidate="rblQdifficulty15" SkinID="DataLabel" TabIn="53" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Question 15 Selection is required."></asp:RequiredFieldValidator>
                                <%--Question 15 Object Data Source--%>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ15" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ15" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Question 15 : Question Number--%>
                                <asp:HiddenField ID="HiddenQ15" runat="server" Visible="false" Value="Follow Up Difficulty-15" />
                            </td>
                        </tr>


                        <tr>
                            <td>&nbsp;
                            </td>
                            <td>
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ16" runat="server" AssociatedControlID="rblQdifficulty16" SkinID="DataLabel" TabIn="54">
                                     <%=GetQuestionText("Follow Up Difficulty-16")%>
                                </asp:Label>
                            </td>
                            <td>
                                <%--Question 16 Choice List--%>
                                <asp:RadioButtonList   name="rblQdifficulty" ID="rblQdifficulty16" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ16" SkinID="DataLabel" TabIn="55"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="radioWithProperWrap" RepeatLayout="Table" ValidationGroup="OnSave"  
                                    AutoPostBack="false">
                                </asp:RadioButtonList>
                                <%--Question 16 Required Validator--%>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ16" runat="server" ControlToValidate="rblQdifficulty16" SkinID="DataLabel" TabIn="56" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Question 16 Selection is required."></asp:RequiredFieldValidator>
                                <%--Question 16 Object Data Source--%>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ16" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ16" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Question 16 : Question Number--%>
                                <asp:HiddenField ID="HiddenQ16" runat="server" Visible="false" Value="Follow Up Difficulty-16" />
                            </td>
                        </tr>


                        <tr>
                            <td>&nbsp;
                            </td>
                            <td>
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ17" runat="server" AssociatedControlID="rblQdifficulty17" SkinID="DataLabel" TabIn="57">
                                     <%=GetQuestionText("Follow Up Difficulty-17")%>
                                </asp:Label>
                            </td>
                            <td>
                                <%--Question 17 Choice List--%>
                                <asp:RadioButtonList   name="rblQdifficulty" ID="rblQdifficulty17" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ17" SkinID="DataLabel" TabIn="58"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="radioWithProperWrap" RepeatLayout="Table" ValidationGroup="OnSave" 
                                    AutoPostBack="false">
                                </asp:RadioButtonList>
                                <%--Question 17 Required Validator--%>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ17" runat="server" ControlToValidate="rblQdifficulty17" SkinID="DataLabel" TabIn="59" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Question 17 Selection is required."></asp:RequiredFieldValidator>
                                <%--Question 17 Object Data Source--%>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ17" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ17" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Question 17 : Question Number--%>
                                <asp:HiddenField ID="HiddenQ17" runat="server" Visible="false" Value="Follow Up Difficulty-17" />
                            </td>
                        </tr>


                        <tr>
                            <td>&nbsp;
                            </td>
                            <td>
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ18" runat="server" AssociatedControlID="rblQdifficulty18" SkinID="DataLabel" TabIn="60">
                                     <%=GetQuestionText("Follow Up Difficulty-18")%>
                                </asp:Label>
                            </td>
                            <td>
                                <%--Question 18 Choice List--%>
                                <asp:RadioButtonList   name="rblQdifficulty" ID="rblQdifficulty18" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ18" SkinID="DataLabel" TabIn="61"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="radioWithProperWrap" RepeatLayout="Table" ValidationGroup="OnSave" 
                                    AutoPostBack="false">
                                </asp:RadioButtonList>
                                <%--Question 18 Required Validator--%>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ18" runat="server" ControlToValidate="rblQdifficulty18" SkinID="DataLabel" TabIn="62" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Question 18 Selection is required."></asp:RequiredFieldValidator>
                                <%--Question 18 Object Data Source--%>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ18" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ18" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Question 18 : Question Number--%>
                                <asp:HiddenField ID="HiddenQ18" runat="server" Visible="false" Value="Follow Up Difficulty-18" />
                            </td>
                        </tr>


                        <tr>
                            <td>&nbsp;
                            </td>
                            <td>
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ19" runat="server" AssociatedControlID="rblQdifficulty19" SkinID="DataLabel" TabIn="63">
                                     <%=GetQuestionText("Follow Up Difficulty-19")%>
                                </asp:Label>
                            </td>
                            <td>
                                <%--Question 19 Choice List--%>
                                <asp:RadioButtonList   name="rblQdifficulty" ID="rblQdifficulty19" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ19" SkinID="DataLabel" TabIn="64"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="radioWithProperWrap" RepeatLayout="Table" ValidationGroup="OnSave" 
                                    AutoPostBack="false">
                                </asp:RadioButtonList>
                                <%--Question 19 Required Validator--%>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ19" runat="server" ControlToValidate="rblQdifficulty19" SkinID="DataLabel" TabIn="65" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Question 19 Selection is required."></asp:RequiredFieldValidator>
                                <%--Question 19 Object Data Source--%>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ19" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ19" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Question 19 : Question Number--%>
                                <asp:HiddenField ID="HiddenQ19" runat="server" Visible="false" Value="Follow Up Difficulty-19" />
                            </td>
                        </tr>


                        <tr>
                            <td>&nbsp;
                            </td>
                            <td>
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ20" runat="server" AssociatedControlID="rblQdifficulty20" SkinID="DataLabel" TabIn="66">
                                     <%=GetQuestionText("Follow Up Difficulty-20")%>
                                </asp:Label>
                            </td>
                            <td>
                                <%--Question 20 Choice List--%>
                                <asp:RadioButtonList   name="rblQdifficulty" ID="rblQdifficulty20" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ20" SkinID="DataLabel" TabIn="67"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="radioWithProperWrap" RepeatLayout="Table" ValidationGroup="OnSave" 
                                    AutoPostBack="false">
                                </asp:RadioButtonList>
                                <%--Question 20 Required Validator--%>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ20" runat="server" ControlToValidate="rblQdifficulty20" SkinID="DataLabel" TabIn="68" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Question 20 Selection is required."></asp:RequiredFieldValidator>
                                <%--Question 20 Object Data Source--%>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ20" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ20" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Question 20 : Question Number--%>
                                <asp:HiddenField ID="HiddenQ20" runat="server" Visible="false" Value="Follow Up Difficulty-20" />
                            </td>
                        </tr>


                        <tr>
                            <td>&nbsp;
                            </td>
                            <td>
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ21" runat="server" AssociatedControlID="rblQdifficulty21" SkinID="DataLabel" TabIn="69">
                                     <%=GetQuestionText("Follow Up Difficulty-21")%>
                                </asp:Label>
                            </td>
                            <td>
                                <%--Question 21 Choice List--%>
                                <asp:RadioButtonList   name="rblQdifficulty" ID="rblQdifficulty21" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ21" SkinID="DataLabel" TabIn="70"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="radioWithProperWrap" RepeatLayout="Table" ValidationGroup="OnSave" 
                                    AutoPostBack="false">
                                </asp:RadioButtonList>
                                <%--Question 21 Required Validator--%>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ21" runat="server" ControlToValidate="rblQdifficulty21" SkinID="DataLabel" TabIn="71" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Question 21 Selection is required."></asp:RequiredFieldValidator>
                                <%--Question 21 Object Data Source--%>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ21" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ21" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Question 21 : Question Number--%>
                                <asp:HiddenField ID="HiddenQ21" runat="server" Visible="false" Value="Follow Up Difficulty-21" />
                            </td>
                        </tr>


                        <tr>
                            <td>&nbsp;
                            </td>
                            <td>
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ22" runat="server" AssociatedControlID="rblQdifficulty22" SkinID="DataLabel" TabIn="72">
                                     <%=GetQuestionText("Follow Up Difficulty-22")%>
                                </asp:Label>
                            </td>
                            <td>
                                <%--Question 22 Choice List--%>
                                <asp:RadioButtonList   name="rblQdifficulty" ID="rblQdifficulty22" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ22" SkinID="DataLabel" TabIn="73"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="radioWithProperWrap" RepeatLayout="Table" ValidationGroup="OnSave" 
                                    AutoPostBack="false" >
                                </asp:RadioButtonList>
                                <%--Question 22 Required Validator--%>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ22" runat="server" ControlToValidate="rblQdifficulty22" SkinID="DataLabel" TabIn="74" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Question 22 Selection is required."></asp:RequiredFieldValidator>
                                <%--Question 22 Object Data Source--%>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ22" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ22" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Question 22 : Question Number--%>
                                <asp:HiddenField ID="HiddenQ22" runat="server" Visible="false" Value="Follow Up Difficulty-22" />
                            </td>
                        </tr>
                        </table>
                    </asp:Panel>
                    <table style="width: 90%;" cellpadding="5">

                        <tr>
                            <td style="width: 20px;">&nbsp;
                            </td>
                            <td>
                                <b>Difficulty Follow Up Score</b>
                                <asp:Button ID="btnCalculateBasicScore" runat="server" Text="Calculate" OnClick="updateTotals" ToolTip="Calculate Basic Score" SkinID="DataLabel"   TabIn="75" />
                               <!-- <input type="button" id="Button1" onclick="sumTotals" value="Calculate"  TabIn="38" visible="false" ></button> -->
                            </td>
                            <td align="right">
                                <b>
                                    <asp:Label ID="lblBasicActivitiesScore" runat="server"  SkinID="DataLabel" Text="_" TabIn="76"></asp:Label><asp:Label ID="lblBasicActivitiesScoreTotal" runat="server"  SkinID="DataLabel" Text="_" TabIn="76">_Total Score For Difficulty Baseline</asp:Label></b>
                                <asp:HiddenField ID="HiddenBasicScore" runat="server" Value="" />
                            </td>
                        </tr>
                        </table>
                    </asp:Panel>
                <br />
                <br />
              
                <asp:Button ID="btnSaveSurveyDraft" runat="server" UseSubmitBehavior="true" Text="Save Draft" Width="130px" OnClick="btnSaveSurveyDraft_Click"
                    ValidationGroup="OnSaveDraft" SkinID="DataLabel"  TabIn="77" />
                <asp:Button ID="btnSubmitSurvey" runat="server" UseSubmitBehavior="true" Text="Save and Prepare Note" Width="180px" OnClick="btnSubmit_Click"
                    ValidationGroup="OnSave"  SkinID="DataLabel" TabIn="78" />
                <asp:Button ID="btnCancelSurvey" runat="server"  SkinID="DataLabel" TabIn="79" UseSubmitBehavior="false" Text="Cancel" Width="130px" OnClick="btnCancel_Click" />
                 <asp:Timer ID="InactiveTimer" Interval="300000" Enabled="true" runat="server" OnTick="InActiveTimer_Tick" />
            </ContentTemplate>
        </asp:UpdatePanel>
    </telerik:RadCodeBlock>
    <br />
    <asp:Label runat="server" ID="cclabel" SkinID="DataLabel" TabIn="80"  Text="Copyright © 2012, 2006, 2005 American Physical Therapy Association. All rights reserved."></asp:Label>
</asp:Content>
